<?

function is_gd_support()
{
	return ((extension_loaded('gd')||extension_loaded('gd2'))&&function_exists('getimagesize'));
}

function img_get_inf($path, $sizecaps=array('Mb','Kb','bytes'))
{
	$ri = array('w'=>0,'h'=>0,'typeid'=>0,'bits'=>0,'mime'=>'','type'=>'','size'=>0,'rsize'=>"");
	if(is_gd_support())
	{
		$ii = getimagesize($path);
		$ri['w'] = $ii[0];
		$ri['h'] = $ii[1];
		$ri['typeid'] = $ii[2];
		if(isset($ii['bits'])){
			$ri['bits']=$ii['bits'];
		}
		if(!isset($ii['mime'])){
			$mimes=array(
				1=>'image/gif',
				2=>'image/jpeg',
				3=>'image/png',
				4=>'application/x-shockwave-flash',
				5=>'image/psd',
				6=>'image/bmp',
				7=>'image/tiff',
				8=>'image/tiff',
				9=>'application/octet-stream',
				10=>'image/jp2',
				11=>'application/octet-stream',
				12=>'application/octet-stream',
				13=>'application/x-shockwave-flash',
				14=>'image/iff',
				15=>'image/vnd.wap.wbmp',
				16=>'image/xbm',
			);
			if(isset($mimes[$ri['typeid']]))
				$ri['mime'] = $mimes[$ri['typeid']];
		}else{
			$ri['mime'] = $ii['mime'];
		}
		$types=array(
			'image/gif'=>'gif',
			'image/jpeg'=>'jpg',
			'image/png'=>'png',
			'application/x-shockwave-flash'=>'swf',
			'image/psd'=>'psd',
			'image/bmp'=>'bmp',
			'image/tiff'=>'tiff',
			'image/jp2'=>'jpg',
			'image/iff'=>'iff',
			'image/vnd.wap.wbmp'=>'wbmp',
			'image/xbm'=>'xbm',
			'application/octet-stream'=>'img',
		);
		if(!empty($ri['mime'])){
			if(isset($types[$ri['mime']])){
				$ri['type']=$types[$ri['mime']];
			}else{
				$ri['type']=end(explode("/",$ri['mime']));
			}
		}
		$ri['size'] = filesize($path);
		if(!(is_array($sizecaps)&&count($sizecaps)==3))
		{
			$sizecaps=array('Mb','Kb','bytes');
		}
		if($ri['size']>=1048576){ $ri['rsize'] = round($ri['size']/1048576, 2)." {$sizecaps[0]}";}
		elseif($ri['size']>1024){ $ri['rsize'] = round($ri['size']/1024, 2)." {$sizecaps[1]}";}
		else{ $ri['rsize'] = "{$ri['rsize']} {$sizecaps[2]}";}
	}
	return $ri;
}

//format: jpg|gif|png
function img_resize($path, $savepath, $max_w=100, $max_h=100, $method=0, $jpg_quality=45, $format="")
{
	if(!is_gd_support()){ return false;}
	if(empty($path) || !(file_exists($path)&&is_file($path))){ return false;}
	if(empty($savepath)){ return false;}
	else{
		$sd=dirname($savepath);
		if(!(file_exists($sd)&&is_dir($sd)&&is_writeable($sd))){ return false;}
		else{
			if(file_exists($savepath)&&is_file($savepath)){
				if(!is_writeable($savepath)){ return false;}
			}
		}
	}

	$ii = img_get_inf($path);
	$img_w = $ii['w'];
	$img_h = $ii['h'];
	$img_type = $ii['type'];
	switch($img_type)
	{
		case "gif":
			$src_img = imagecreatefromgif($path);
			break;
		case "jpg":
			$src_img = imagecreatefromjpeg($path);
			break;
		case "png":
			$src_img = imagecreatefrompng($path);
			break;
		default:
			$img_type = "jpg";
			$src_img = imagecreatefromjpeg($path);
			break;
	}

	if($img_w>$max_w || $img_h>$max_h)
	{
		$ratio_w = $img_w/$max_w;
		$ratio_h = $img_h/$max_h;
		if($ratio_w < $ratio_h)
		{
			$new_w = floor($img_w/$ratio_h);
			$new_h = $max_h;
		}
		else
		{
			$new_w = $max_w;
			$new_h = floor($img_h/$ratio_w);
		}
		$dst_img = imagecreatetruecolor($new_w, $new_h);
		switch($method)
		{
			case 1:
				imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $new_w, $new_h, $img_w, $img_h);
				break;
			default:
				imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $new_w, $new_h, $img_w, $img_h);
				break;
		}

		if(empty($format))$format=$img_type;
		switch($format)
		{
			case "jpg":
				imagejpeg($dst_img, $savepath, $jpg_quality);
				break;
			case "gif":
				imagegif($dst_img, $savepath);
				break;
			case "png":
				imagepng($dst_img, $savepath);
				break;
		}
	}
	return true;
}

?>