/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 *
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 *
 * For further information visit:
 * 		http://www.fckeditor.net/
 *
 * File Name: FCKeditor.java
 * 	FCKeditor control class.
 *
 * Version:  2.3
 * Modified: 2005-08-11 16:29:00
 *
 * File Authors:
 * 		Simone Chiaretta (simo@users.sourceforge.net)
 *
 * Version:  2.5
 * Modified: 2007-12-27 23:04:00
 *
 * File Authors:
 * 		Axel Muench, Specto Design, Inc.
 */


package com.fredck.FCKeditor;


import javax.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * The main class of the class lib.<br>
 * <p/>
 * It's the container for all properties and the class that generate the output based on browser capabilities and configurations passed by the developer.
 *
 * @author Simone Chiaretta (simo@users.sourceforge.net)
 */

public class FCKeditor {


    private FCKeditorConfigurations oConfig;

    private String instanceName;

    private String value = "";

    private String basePath;

    private String toolbarSet = "Default";

    private String width = "100%";

    private String height = "200";


    HttpServletRequest request;



    /**
     * Get the unique name of the editor
     *
     * @return name
     */

    public String getInstanceName() {

        return instanceName;

    }



    /**
     * Set the unique name of the editor
     *
     * @param value name
     */

    public void setInstanceName(String value) {

        instanceName = value;

    }



    /**
     * Get the initial value to be edited.<br>
     * <p/>
     * In HTML code
     *
     * @return value
     */

    public String getValue() {

        return value;

    }



    /**
     * Set the initial value to be edited.<br>
     * <p/>
     * In HTML code
     *
     * @param value value
     */

    public void setValue(String value) {

        this.value = value;

    }



    /**
     * Get the dir where the FCKeditor files reside on the server
     *
     * @return path
     */

    public String getBasePath() {

        return basePath;

    }



    /**
     * Set the dir where the FCKeditor files reside on the server.<br>
     * <p/>
     * <b>Remarks</b>:<br>
     * <p/>
     * Avoid using relative paths. It is preferable to set the base path starting from the root (/).<br>
     * <p/>
     * Always finish the path with a slash (/).
     *
     * @param value path
     */

    public void setBasePath(String value) {

        basePath = value;

    }



    /**
     * Get the name of the toolbar to display
     *
     * @return toolbar name
     */

    public String getToolbarSet() {

        return toolbarSet;

    }



    /**
     * Set the name of the toolbar to display
     *
     * @param value toolbar name
     */

    public void setToolbarSet(String value) {

        toolbarSet = value;

    }



    /**
     * Get the width of the textarea
     *
     * @return width
     */

    public String getWidth() {

        return width;

    }



    /**
     * Set the width of the textarea
     *
     * @param value width
     */

    public void setWidth(String value) {

        width = value;

    }



    /**
     * Get the height of the textarea
     *
     * @return height
     */

    public String getHeight() {

        return height;

    }



    /**
     * Set the height of the textarea
     *
     * @param value height
     */

    public void setHeight(String value) {

        height = value;

    }



    /**
     * Get the advanced configuation set.<br>
     * <p/>
     * Adding element to this collection you can override the settings specified in the config.js file.
     *
     * @return configuration collection
     */

    public FCKeditorConfigurations getConfig() {

        return oConfig;

    }



    /**
     * Set the advanced configuation set.
     *
     * @param value configuration collection
     */

    public void setConfig(FCKeditorConfigurations value) {

        oConfig = value;

    }



    /**
     * Initialize the object setting all value to the default ones.
     * <p/>
     * <p>
     * <p/>
     * <ul>
     * <p/>
     * <li>width: 100%</li>
     * <p/>
     * <li>height: 200</li>
     * <p/>
     * <li>toolbar name: Default</li>
     * <p/>
     * <li>basePath: context root + "/FCKeditor/"</li>
     * <p/>
     * </ul>
     * <p/>
     * </p>
     *
     * @param req request object
     */

    public FCKeditor(HttpServletRequest req) {

        request = req;

        basePath = request.getContextPath() + "/FCKeditor/";

        oConfig = new FCKeditorConfigurations();

    }



    /**
     * Initialize the object setting the unique name and then all value to the default ones.
     * <p/>
     * <p>
     * <p/>
     * <ul>
     * <p/>
     * <li>width: 100%</li>
     * <p/>
     * <li>height: 200</li>
     * <p/>
     * <li>toolbar name: Default</li>
     * <p/>
     * <li>basePath: context root + "/FCKeditor/"</li>
     * <p/>
     * </ul>
     * <p/>
     * </p>
     *
     * @param req             request object
     * @param parInstanceName unique name
     */

    public FCKeditor(HttpServletRequest req, String parInstanceName) {

        request = req;

        basePath = request.getContextPath() + "/FCKeditor/";

        instanceName = parInstanceName;

        oConfig = new FCKeditorConfigurations();

    }



    /**
     * Initialize the object setting all basic configurations.<br>
     * <p/>
     * <p/>
     * <p/>
     * The basePath is context root + "/FCKeditor/"
     *
     * @param req             request object
     * @param parInstanceName unique name
     * @param parWidth        width
     * @param parHeight       height
     * @param parToolbarSet   toolbarSet name
     * @param parValue        initial value
     */

    public FCKeditor(HttpServletRequest req, String parInstanceName, String parWidth, String parHeight, String parToolbarSet, String parValue) {

        request = req;

        basePath = request.getContextPath() + "/FCKeditor/";

        instanceName = parInstanceName;

        width = parWidth;

        height = parHeight;

        toolbarSet = parToolbarSet;

        value = parValue;

        oConfig = new FCKeditorConfigurations();

    }



    private boolean isCompatible() {

        String userAgent = request.getHeader("user-agent");

        if (userAgent == null) {
            return false;
        } else {
            userAgent = userAgent.toLowerCase();
        }

        if ((userAgent.indexOf("msie") != -1) && (userAgent.indexOf("mac") == -1) && (userAgent.indexOf("opera") == -1)) {

            return (retrieveBrowserVersion(userAgent) >= 5.5);


        } else if (userAgent.indexOf("gecko") != -1 && userAgent.indexOf("applewebkit") < 0) {

            return (retrieveBrowserVersion(userAgent) >= 20030210);


        } else if (userAgent.indexOf("applewebkit") != -1) {

            return (retrieveBrowserVersion(userAgent) >= 522);


        } else if (userAgent.indexOf("opera") != -1) {

            return (retrieveBrowserVersion(userAgent) >= 9.5);

        }

        return false;

    }



    private double retrieveBrowserVersion(String userAgent) {

        if (userAgent.indexOf("msie") > -1) {

            String str = userAgent.substring(userAgent.indexOf("msie") + 5);

            try {
                return Double.parseDouble(str.substring(0, str.indexOf(";")));
            } catch (NumberFormatException e) {
                return 0;
            }


        } else if (userAgent.indexOf("gecko") != -1 && userAgent.indexOf("applewebkit") < 0) {

            String str = userAgent.substring(userAgent.indexOf("gecko") + 6);

            try {
                return Double.parseDouble(str.substring(0, 8));
            } catch (NumberFormatException e) {
                return 0;
            }


        } else if (userAgent.indexOf("applewebkit") != -1) {

            Matcher safari = Pattern.compile("applewebkit/" + "(( [\\d]* )" + "(?:" + "\\." + " [\\d]* )?)", Pattern.COMMENTS).matcher(userAgent);
            safari.find();
            int majorVersion = 0;
            try {
                majorVersion = Integer.parseInt(safari.group(2));
            }
            catch (NumberFormatException nfe) {
                // ignored
            }
            return majorVersion;
            

        } else if (userAgent.indexOf("opera") != -1) {

            String str = userAgent.substring(userAgent.indexOf("opera") + 6);

            try {
                return  Double.parseDouble(str.substring(0, 4));
            } catch (NumberFormatException e) {
                return 0;
            }


        } else {

            return 0;
        }

    }



    private String HTMLEncode(String txt) {

        txt = txt.replaceAll("&", "&amp;");

        txt = txt.replaceAll("<", "&lt;");

        txt = txt.replaceAll(">", "&gt;");

        txt = txt.replaceAll("\"", "&quot;");

        txt = txt.replaceAll("'", "&#146;");

        return txt;

    }



    /**
     * Generate the HTML Code for the editor.
     * <p/>
     * <br>
     * <p/>
     * Evalute the browser capabilities and generate the editor if IE 5.5 or Gecko 20030210 or greater,
     * <p/>
     * or a simple textarea otherwise.
     *
     * @return html code
     */

    public String createHtml() {

        StringBuffer strEditor = new StringBuffer(128);


        strEditor.append("<div>");

        String encodedValue = HTMLEncode(value);


        if (isCompatible()) {

            strEditor.append("<input type=\"hidden\" id=\"").append(instanceName).append("\" name=\"").append(instanceName).append("\" value=\"").append(encodedValue).append("\">");


            strEditor.append(createConfigHTML());

            strEditor.append(createIFrameHTML());


        } else {

            strEditor.append("<TEXTAREA name=\"").append(instanceName).append("\" rows=\"4\" cols=\"40\" style=\"WIDTH: ").append(width).append("; HEIGHT: ").append(height).append("\" wrap=\"virtual\">").append(encodedValue).append("</TEXTAREA>");

        }

        strEditor.append("</div>");

        return strEditor.toString();

    }



    /**
     *  @deprecated   Use createHtml() instead
     *  @return html  code
     */

    public String create() {

        return createHtml();

    }



    private String createConfigHTML() {

        String configStr = oConfig.getUrlParams();


        if (!configStr.equals(""))

            configStr = configStr.substring(1);


        return new StringBuffer(128).append("<input type=\"hidden\" id=\"").append(instanceName).append("___Config\" value=\"").append(configStr).append("\">").toString();

    }



    private String createIFrameHTML() {


        String sLink = basePath + "editor/fckeditor.html?InstanceName=" + instanceName;


        if (!toolbarSet.equals(""))

            sLink += "&Toolbar=" + toolbarSet;


        return new StringBuffer(128).append("<iframe id=\"").append(instanceName).append("___Frame\" src=\"").append(sLink).append("\" width=\"").append(width).append("\" height=\"").append(height).append("\" frameborder=\"no\" scrolling=\"no\"></iframe>").toString();


    }


}

