﻿////////////////////////////////////////////////////
// controlWindow object
////////////////////////////////////////////////////
function controlWindow( controlForm ) {
	// private properties
	this._form = controlForm;
	this.bUndoDisabled = true;
	this.bControlsDisabled = true;
	this.bUseAddButton = false;
	
	// private methods
	this._setButtons = _setButtons;

	// public properties
	this.windowType = "controlWindow";
//	this.noSuggestionSelection = "- No suggestions -";	// by FredCK
	this.noSuggestionSelection = FCKLang.DlgSpellNoSuggestions ;
	// set up the properties for elements of the given control form
	this.suggestionList  = this._form.sugg;
	this.evaluatedText   = this._form.misword;
	this.replacementText = this._form.txtsugg;
	this.undoButton      = this._form.btnUndo;

	// public methods
	this.addSuggestion = addSuggestion;
	this.clearSuggestions = clearSuggestions;
	this.selectDefaultSuggestion = selectDefaultSuggestion;
	this.resetForm = resetForm;
	this.setSuggestedText = setSuggestedText;
	this.enableUndo = enableUndo;
	this.disableUndo = disableUndo;
	this.enableControls = enableControls;
}

function resetForm() {
	if( this._form ) {
		this._form.reset();
	}
}

function setSuggestedText() {
	var slct = this.suggestionList;
	var txt = this.replacementText;
	var str = "";
	if( (slct.options[0].text) && slct.options[0].text != this.noSuggestionSelection ) {
		str = slct.options[slct.selectedIndex].text;
	}
	txt.value = str;
}

function selectDefaultSuggestion() {
	var slct = this.suggestionList;
	var txt = this.replacementText;
	if( slct.options.length == 0 ) {
		this.addSuggestion( this.noSuggestionSelection );
	} else {
		slct.options[0].selected = true;
	}
	this.setSuggestedText();
}

function addSuggestion( sugg_text ) {
	var slct = this.suggestionList;
	if( sugg_text ) {
		var i = slct.options.length;
		var newOption = new Option( sugg_text, 'sugg_text'+i );
		slct.options[i] = newOption;
	 }
}

function clearSuggestions() {
	var slct = this.suggestionList;
	for( var j = slct.length - 1; j > -1; j-- ) {
		if( slct.options[j] ) {
			slct.options[j] = null;
		}
	}
}

function enableUndo() {
	this.bUndoDisabled = false;
	this._setButtons();
}

function disableUndo() {
	this.bUndoDisabled = true;
	this._setButtons();
}

function enableControls(bEnable) {
	this.bControlsDisabled = bEnable ? false : true;
	this._setButtons();
}

function _setButtons() {
	var oForm = this._form;
	if(!oForm)
		return;

	var oBtnAdd = oForm.btnAdd;
    oBtnAdd.style.visibility = (this.bUseAddButton ? "visible" : "hidden");
	oBtnAdd.disabled = this.bControlsDisabled;
	oForm.btnUndo.disabled = (this.bControlsDisabled || this.bUndoDisabled) ? true : false;

	oForm.btnReplaceAll.disabled = this.bControlsDisabled;
	oForm.btnReplace.disabled = this.bControlsDisabled;
	oForm.btnIgnoreAll.disabled = this.bControlsDisabled;
	oForm.btnIgnore.disabled = this.bControlsDisabled;
}