#!/usr/bin/perl

use CGI qw/ :standard /;
use File::Temp qw/ tempfile tempdir /;

# my $spellercss = '/speller/spellerStyle.css';					# by FredCK
my $spellercss = '../spellerStyle.css';							# by FredCK
# my $wordWindowSrc = '/speller/wordWindow.js';					# by FredCK
my $wordWindowSrc = '../wordWindow.js';							# by FredCK
my @textinputs = param( 'textinputs[]' ); # array
# my $aspell_cmd = 'aspell';									# by FredCK (for Linux)
#my $aspell_cmd = '"C:\Program Files\Aspell\bin\aspell.exe"';	# by FredCK (for Windows)
my $aspell_cmd = '"C:\Program Files (x86)\Aspell\bin\aspell.exe"';	# By HTB
my $lang = 'en_US';
# my $aspell_opts = "-a --lang=$lang --encoding=utf-8";			# by FredCK
my $aspell_opts = "-a --lang=$lang --encoding=utf-8 -H --rem-sgml-check=alt";		# by FredCK
my $input_separator = "A";

# TBD: Define this function for your server environment
sub serverAddWords() {
	my $rWords = shift;	# arrayref of words to add to server
	# TBD: server specific: add missing words in @{$rWords} to dictionary
	return 1;	# return 1 if OK, 0 if failed
}

# TBD: Define this function for your server environment
sub serverGetWords() {
	my @Words;
	# TBD: server specific: put words from dictionary into \@Words
	return \@Words;
}

# see if called to add words
if(defined(param("addwords"))) {
	&addWords();
	exit;
}

# set the 'wordtext' JavaScript variable to the submitted text.
sub printTextVar {
	for( my $i = 0; $i <= $#textinputs; $i++ ) {
	        print "textinputs[$i] = decodeURIComponent('" . escapeQuote( $textinputs[$i] ) . "')\n";
	}
}

sub printTextIdxDecl {
	my $idx = shift;
	print "words[$idx] = [];\n";
	print "suggs[$idx] = [];\n";
}

sub printWordsElem {
	my( $textIdx, $wordIdx, $word ) = @_;
	print "words[$textIdx][$wordIdx] = '" . $word . "';\n";
}

sub printSuggsElem {
	my( $textIdx, $wordIdx, @suggs ) = @_;
	print "suggs[$textIdx][$wordIdx] = [";
	for my $i ( 0..$#suggs ) {
		print "'" . escapeQuote( $suggs[$i] ) . "'";
		if( $i < $#suggs ) {
			print ", ";
		}
	}
	print "];\n";
}

sub printCheckerResults {
	my $textInputIdx = -1;
	my $wordIdx = 0;
	my $unhandledText;
	# create temp file
	my $dir = tempdir( CLEANUP => 1 );
	my( $fh, $tmpfilename ) = tempfile( DIR => $dir );

	# temp file was created properly?

	# open temp file, add the submitted text.
	for( my $i = 0; $i <= $#textinputs; $i++ ) {
		$text = url_decode( $textinputs[$i] );
		# Strip all tags for the text. (by FredCK - #339 / #681)
		$text =~ s/<[^>]+>/ /g;
		@lines = split( /\n/, $text );
		print $fh "\%\n"; # exit terse mode
		print $fh "^$input_separator\n";
		print $fh "!\n";  # enter terse mode
		for my $line ( @lines ) {
			# use carat on each line to escape possible aspell commands
			print $fh "^$line\n";
		}

	}

	# get words from dictionary
	my $rWords = &serverGetWords();
	my %WordMap = map{$_,1} @{$rWords};	# create hash <word> => 1 for each word

	# exec aspell command
	my $cmd = "$aspell_cmd $aspell_opts < $tmpfilename 2>&1";
	open ASPELL, "$cmd |" or handleError( "Could not execute `$cmd`\\n$!" ) and return;
	# parse each line of aspell return
	for my $ret ( <ASPELL> ) {
		chomp( $ret );
		# if '&', then not in dictionary but has suggestions
		# if '#', then not in dictionary and no suggestions
		# if '*', then it is a delimiter between text inputs
		if( $ret =~ /^\*/ ) {
			$textInputIdx++;
			printTextIdxDecl( $textInputIdx );
			$wordIdx = 0;

		} elsif( $ret =~ /^(&|#)/ ) {
			my @tokens = split( " ", $ret, 5 );

			# Ignore words that are in dictionary
			my $sWord = escapeQuote($tokens[1]);
			next if defined($WordMap{$sWord});

			printWordsElem( $textInputIdx, $wordIdx, $sWord );
			
			my @suggs = ();
			if( $tokens[4] ) {
				@suggs = split( ", ", $tokens[4] );
			}
			printSuggsElem( $textInputIdx, $wordIdx, @suggs );
			$wordIdx++;
		} else {
			$unhandledText .= $ret;
		}
	}
	close ASPELL or handleError( "Error executing `$cmd`\\n$unhandledText" ) and return;
}

sub escapeQuote {
	my $str = shift;
	$str =~ s/'/\\'/g;
	return $str;
}

sub handleError {
	my $err = shift;
	print "error = '" . escapeQuote( $err ) . "';\n";
}

sub url_decode {
	local $_ = @_ ? shift : $_;
	defined or return;
	# change + signs to spaces
	tr/+/ /;
	# change hex escapes to the proper characters
	s/%([a-fA-F0-9]{2})/pack "H2", $1/eg;
	return $_;
}

# add words function
sub addWords() {
	my $sWords = param("words");
	return (undef, "No words to add!") if(!defined($sWords));

	# URI decode: change + signs to spaces and unescape hex escapes
	$sWords = &url_decode($sWords);

	# Split into words
	my @Words = split(/ /, $sWords);

	my $bResult = &serverAddWords(\@Words);
	&printAddWordsOutput($bResult);
}

sub printAddWordsOutput() {
	my $bResult = shift;
	
	print <<EOF;
Content-type: text/html; charset=utf-8

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="$spellercss"/>
<script src="$wordWindowSrc"></script>
<script type="text/javascript">
function close_spell() {	// calls the closeSpeller() function in the parent frameset
if(parent.frames.length && parent.opener && !parent.opener.closed && parent.opener.speller)
 parent.opener.speller.closeSpeller();
}
</script>
</head>
<body onLoad="close_spell();">
<p>&nbsp;</p>
</body></html>
EOF
}

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# Display HTML
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

print <<EOF;
Content-type: text/html; charset=utf-8

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="$spellercss"/>
<script src="$wordWindowSrc"></script>
<script type="text/javascript">
var suggs = new Array();
var words = new Array();
var textinputs = new Array();
var error;
EOF

printTextVar();

printCheckerResults();

print <<EOF;
var wordWindowObj = new wordWindow();
wordWindowObj.originalSpellings = words;
wordWindowObj.suggestions = suggs;
wordWindowObj.textInputs = textinputs;


function init_spell() {
	// check if any error occured during server-side processing
	if( error ) {
		alert( error );
	} else {
		// call the init_spell() function in the parent frameset
		if (parent.frames.length) {
			parent.init_spell( wordWindowObj );
		} else {
			error = "This page was loaded outside of a frameset. ";
			error += "It might not display properly";
			alert( error );
		}
	}
}

</script>

</head>
<body onLoad="init_spell();">

<script type="text/javascript">
wordWindowObj.writeBody();
</script>

</body>
</html>
EOF
