﻿/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'checkbox', function( editor )
{
	return {
		title : editor.lang.checkboxAndRadio.checkboxTitle,
		minWidth : 350,
		minHeight : 140,
		onShow : function()
		{
			/*
			delete this.checkbox;

			
			var element = this.getParentEditor().getSelection().getSelectedElement();

			if ( element && element.getAttribute( 'type' ) == "checkbox" )
			{
				this.checkbox = element;
				this.setupContent( element );
			}*/
			
			delete this.checkbox;

			this.fakeObj = false;
			this.editMode = false;
			
			var selection = editor.getSelection();
			var element = selection.getSelectedElement();
			if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'checkbox' )
			{
				this.fakeObj = element;
				element = editor.restoreRealElement( this.fakeObj );
				this.checkbox = element;
				this.editMode = true;
				this.setupContent(element);
				selection.selectElement( this.fakeObj );
			}
			
			//this.getContentElement( 'info', 'txtName' ).focus();
		},
		onOk : function()
		{
			/*

			var editor,
				element = this.checkbox,
				isInsertMode = !element;

			if ( isInsertMode )
			{
				editor = this.getParentEditor();
				element = editor.document.createElement( 'input' );
				element.setAttribute( 'type', 'checkbox' );
			}

			if ( isInsertMode )
				editor.insertElement( element );
			this.commitContent( { element : element } );
			*/
			
			// Always create a new radio, because of IE BUG.
			var name = this.getValueOf( 'info', 'txtName' ),
				value = this.getValueOf( 'info', 'txtValue' ),
				isChecked = !!this.getValueOf( 'info', 'cmbSelected' ),
				element = CKEDITOR.env.ie ?
				editor.document.createElement( '<input type="checkbox" name="' + CKEDITOR.tools.htmlEncode( name ) + '" value="' + CKEDITOR.tools.htmlEncode( value ) + '" '+ ( isChecked ? ' checked="checked"' : '' )+'>' ) :
				editor.document.createElement( 'input' );

			// Move contents and attributes of old anchor to new checkbox.
			if ( this.editMode )
			{
				this.checkbox.copyAttributes( element, { type: 1, name : 1, value : 1 } );
				this.checkbox.moveChildren( element );
			}

			// Set name.
			element.removeAttribute( '_cke_saved_name' );
			element.setAttribute( 'name', name );
			element.setAttribute( 'value', value );
			
			var type = 'cke_checkbox';
			
			if(!isChecked)
			{
				element.removeAttribute( 'checked' );
			}else
			{
				type = 'cke_checkbox_checked';
				element.setAttribute( 'checked', 'checked' );
			}


			// Insert a new checkbox.
			var fakeElement = editor.createFakeElement( element, type, 'checkbox' );
			if ( !this.editMode )
				editor.insertElement( fakeElement );
			else
			{
				fakeElement.replace( this.fakeObj );
				editor.getSelection().selectElement( fakeElement );
			}
			
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.checkboxAndRadio.checkboxTitle,
				title : editor.lang.checkboxAndRadio.checkboxTitle,
				startupFocus : 'txtName',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						setup : function( element )
						{
							this.setValue(
									element.getAttribute( '_cke_saved_name' ) ||
									element.getAttribute( 'name' ) ||
									'' );
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.checkboxAndRadio.value,
						'default' : '',
						accessKey : 'V',
						setup : function( element )
						{
							this.setValue( element.getAttribute( 'value' ) || '' );
						}
					},
					{
						id : 'cmbSelected',
						type : 'checkbox',
						label : editor.lang.checkboxAndRadio.selected,
						'default' : '',
						accessKey : 'S',
						value : "checked",
						setup : function( element )
						{
							this.setValue( element.getAttribute( 'checked' ) );
						}
					}
				]
			}
		]
	};
});
