﻿/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

(function()
{
	CKEDITOR.plugins.liststyle =
	{
		init : function( editor )
		{

			editor.addCommand( 'numberedListStyle', new CKEDITOR.dialogCommand( 'numberedListStyle' ) );
			CKEDITOR.dialog.add( 'numberedListStyle', this.path + 'dialogs/liststyle.js' );
			editor.addCommand( 'bulletedListStyle', new CKEDITOR.dialogCommand( 'bulletedListStyle' ) );
			CKEDITOR.dialog.add( 'bulletedListStyle', this.path + 'dialogs/liststyle.js' );

		
			//Register map group;
			editor.addMenuGroup("list", 108);
			// If the "menu" plugin is loaded, register the menu items.
			if ( editor.addMenuItems )
			{
				editor.addMenuItems(
					{
						numberedlist :
						{
							label : 'Numbered List Properties',
							group : 'list',
							command: 'numberedListStyle'
						},
						bulletedlist :
						{
							label : 'Bulleted List Properties',
							group : 'list',
							command: 'bulletedListStyle'
						}
					});
			}
		
			// If the "contextmenu" plugin is laoded, register the listeners.
			if ( editor.contextMenu )
			{
				editor.contextMenu.addListener( function( element, selection )
					{
						if ( !element )
							return null;
						
						if ( element.getAscendant( 'ol') ) {
							return { numberedlist: CKEDITOR.TRISTATE_OFF }
						}
						if ( element.getAscendant( 'ul' ) ) {
							return { bulletedlist: CKEDITOR.TRISTATE_OFF }
						}
					} );
			}
		}

	};
	
	CKEDITOR.plugins.add( 'liststyle', CKEDITOR.plugins.liststyle );
})();
