(function() {
	var rangeOnMouseDown = null; // Stores the cursor position when the user first clicked.

	function getRangeAtPoint(px, py) {
		var range = ck.document.$.body.createTextRange();
		try {
			range.moveToPoint(px, py);
		} catch (e) {
			//If moveToPoint fails due to an IE bug ('Unknown Error'), just go to the end of the current range.
			range.collapse(false);
		}
		return range;
	}

	function getRangeAtEndOfDoc() {
		var range = ck.document.$.body.createTextRange();
		range.expand('textedit');
		range.collapse(false); // false == move to end
		return range;
	}

	function getRangeAtBeginOfDoc() {
		var range = ck.document.$.body.createTextRange();
		range.expand('textedit');
		range.collapse(true); // true == move to start.
		return range;
	}

	var fxnSelectFromMouseToEndOfDoc = function(event) {
		event.preventDefault();
		if (event.button !== 1) {
			// The mouse button has been released, but we didn't get a mouseup event, so lets unbind.
			jDocHtml.unbind('mousemove.ieselectionfix');
			return;
		}

		try {
			var rangeCurrent = getRangeAtPoint(event.pageX, event.pageY);
			// If the range has no parent element, the mouse is probably between paragraphs.
			// IE will move the range to the beginning of the document. This creates lots of
			// obnoxious flashing when selecting across paragraphs, so don't do anything when
			// this happens.
			if (!rangeCurrent.parentElement()) {
				return;
			}

			var rangeToSelect = ck.document.$.body.createTextRange();
			if (rangeCurrent.compareEndPoints('StartToStart', rangeOnMouseDown) > 0) {
				// rangeCurrent is at or right of rangeOnMouseDown.
				rangeToSelect.setEndPoint('StartToStart', rangeOnMouseDown);
				rangeToSelect.setEndPoint('EndToEnd', rangeCurrent);
			} else {
				// rangeCurrent is left of rangeOnMouseDown.
				rangeToSelect.setEndPoint('StartToStart', rangeCurrent);
				rangeToSelect.setEndPoint('EndToEnd', rangeOnMouseDown);
			}
			rangeToSelect.select();
		} catch (exception) {
			;
		}
	};

	var jDocHtml = $('html', ck.document.$);
	jDocHtml.mousedown(function(event) {
		// We only want to move the cursor if nothing inside the document was clicked
		if (event.target == this) {
			//alert(event.target.tagName);
			try {
				rangeOnMouseDown = getRangeAtPoint(event.pageX, event.pageY);
				rangeOnMouseDown.select();
				jDocHtml.bind('mousemove.ieselectionfix', fxnSelectFromMouseToEndOfDoc);
			} catch (exc) {
				//alert('error');
				jDocHtml.unbind('mousemove.ieselectionfix');
			}
			event.preventDefault();
		}
	});

	jDocHtml.mouseup(function(event) {
		jDocHtml.unbind('mousemove.ieselectionfix');
	});

	// When the user double-clicks, select the word underneath their cursor.
	jDocHtml.dblclick(function(event) {
		if (event.target == this) {
			try {
				var range = getRangeAtPoint(event.pageX, event.pageY);
				range.expand('word');
				range.select();
			} catch (exc) {
				;
			}
		}
	});
} ());