﻿<%@ Page Language="C#" AutoEventWireup="true"%>
<script language="C#" runat="server">
    private int ActiveIndex
    {
        get
        {
            if (Session["ActiveIndex"] == null)
                Session["ActiveIndex"] = 0;
            return (int)Session["ActiveIndex"];
        }
        set { Session["ActiveIndex"] = value; }
    }

    protected override void OnLoad(EventArgs e)
    {
        base.OnLoad(e);

        if (!Page.IsPostBack)
        {
            ActiveIndex = 0;
        }
    }

    protected override void OnPreRender(EventArgs e)
    {
        base.OnPreRender(e);

        SetActiveTab();
    }

    private void SetActiveTab()
    {
        int i = 0;
        foreach (Control control in Editors.Controls)
        {
            var ct = control as HtmlGenericControl;

            if (ct == null)
                continue;

            if (i == ActiveIndex)
            {
                ct.Visible = true;
            }
            else
                ct.Visible = false;
            i++;
        }
    }

    protected void tab1_Click(object sender, EventArgs e)
	{
        ActiveIndex = 0;
	}
    protected void tab2_Click(object sender, EventArgs e)
	{
        ActiveIndex = 1;
	}
    protected void tab3_Click(object sender, EventArgs e)
	{
        ActiveIndex = 2;
	}
    
	protected void Button1_Click(object sender, EventArgs e)
	{
        Label1.Text = txtContent.Text;
	}
	protected void Button2_Click(object sender, EventArgs e)
	{
        Label2.Text = "Button2_Clicked";
	}
	protected void Button3_Click(object sender, EventArgs e)
	{
        Label3.Text = "Button3_Clicked";
	}
</script>
<%@ Register Assembly="CKEditor.NET" Namespace="CKEditor.NET" TagPrefix="CKEditor" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title></title>
</head>
<body>
	<form id="form1" runat="server">
	    <asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout ="360000">
            <Scripts>
            </Scripts>
        </asp:ScriptManager>
	    <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Always">
	        <ContentTemplate>
	            <div id="tabMenu">
		            <a ID="tab1" runat="server" OnServerClick="tab1_Click">Tab1</a>
		            <a ID="tab2" runat="server" OnServerClick="tab2_Click">Tab2</a>
		            <a ID="tab3" runat="server" OnServerClick="tab3_Click">Tab3</a>
	            </div>
	            <hr />
	            <div id="Editors" runat="server">
	                <div id="editor1" runat="server">
	                    <CKEditor:CKEditorControl ID="txtContent" runat="server" Height="200" Width="800">
                        &lt;p&gt;
                        This is some &lt;strong&gt;sample text&lt;/strong&gt;. You are using &lt;a href="http://ckeditor.com/"&gt;CKEditor&lt;/a&gt;.&lt;/p&gt;
                        &lt;h2&gt;CKEditor 1&lt;/h2&gt;
			            </CKEditor:CKEditorControl>
		                <asp:Label ID="Label1" runat="server" Text="View 1 - Editor 1"></asp:Label>
		                <asp:Button ID="Button1" runat="server" Text="Send 1" onclick="Button1_Click" />
		                <asp:LinkButton ID="LinkButton1" runat="server" PostBackUrl="http://ckeditor.com/">LinkButton</asp:LinkButton>
		            </div>
		            <div id="editor2" runat="server">
			            <asp:Label ID="Label2" runat="server" Text="View 2 - Editor 2"></asp:Label>
			            <asp:Button ID="Button2" runat="server" Text="Send 2" onclick="Button2_Click" />
			            <asp:LinkButton ID="LinkButton2" runat="server">LinkButton</asp:LinkButton>
		            </div>
		            <div id="editor3" runat="server">
		                <asp:Label ID="Label3" runat="server" Text="View 3 - Editor 3"></asp:Label>
		                <asp:Button ID="Button3" runat="server" Text="Send 3" onclick="Button3_Click" />
		                <asp:LinkButton ID="LinkButton3" runat="server" OnClientClick="return false;">LinkButton</asp:LinkButton>
		            </div>
	            </div>
	        </ContentTemplate>
	    </asp:UpdatePanel>
	</form>
</body>
</html>
