
CKEDITOR.dialog.add( 'scriptcode', function( editor )
{
    function reloadEditordata( editor ) {
		var editordata = editor.getData();
		editor.setData(editordata);
    }
    
	return {
		onOk : function()
		{
			var text = this.getContentElement( 'tabcode', 'codearea' ).getInputElement().getValue(),
				editor = this.getParentEditor();

			editor.insertHtml( text );
			reloadEditordata( editor );
        },
		title : 'Quellcode einfügen/bearbeiten',
		minWidth : 450,
		minHeight : 250,
		contents :
        [
    		{
    			id : 'tabcode',
    			label : '',
    			title : '',
    			elements :
                [
        			{
        				type : 'html',
    			        html : 'PHP, Javascript und HTML Quellcode einfügen oder bearbeiten.'
                	},
                    {
        				type : 'textarea',
        				id : 'codearea',
        				rows : '15',
                		onShow : function()
                		{
                            var sel = editor.getSelection(),
                				element = sel.getSelectedElement();
                            this.setValue( element.data( 'cke-realelement' ) );
                        },
                		onHide : function()
                		{
                            this.setValue( '' );
                		}
        			}
                ]
            }
        ]
    }
});







