
(function()
{
    Array.prototype.PosInArray = function(needle)
    {
        for(var i = 0; i < this.length; i++) {
            if(needle === '{cke_protected}' + encodeURIComponent( this[i] )) {
                return i;
                break;
            }
        }
        return false;
    };
    
    function createCodePlaceholder( editor, element )
    {
    	var editordata = editor.getData();
        var phpmatches = editordata.match( /<\?[\s\S]*?\?>/gi );
        var scriptmatches = editordata.match( /<script[\s\S]*?<\/script>/gi );
        var phpPos = false;
        var jsPos = false;
    
        var attributes =
        {
    		src : CKEDITOR.getUrl( 'images/spacer.gif' ),
            'data-cke-real-element-type' : 'code',
            'data-cke-resizable' : false
        };
        
        if(phpmatches)
            phpPos = phpmatches.PosInArray( element );
        if(scriptmatches)
            jsPos = scriptmatches.PosInArray( element );
            
        attributes[ 'class' ] = '';
        attributes[ 'data-cke-realelement' ] = '';
        
        if(phpPos !== false) {
            attributes[ 'class' ] = 'cke_phpcode';
            
            
            attributes[ 'data-cke-realelement' ] = encodeURIComponent( phpmatches[phpPos] );
            // produce: <?php echo=""></?php>
            
            
            //attributes[ 'data-cke-realelement' ] = phpmatches[phpPos];
            // produce: &lt;?php echo &quot;text&quot;; ?&gt;
            
            
            phpPos = false;
            return new CKEDITOR.htmlParser.element( 'img', attributes );
        }
        else if(jsPos !== false) {
            attributes[ 'class' ] = 'cke_jscode';
            
            attributes[ 'data-cke-realelement' ] = encodeURIComponent( scriptmatches[jsPos] );
            // placeholder works
            
            
            //attributes[ 'data-cke-realelement' ] = scriptmatches[jsPos];
            // produce: &lt;script type=&quot;text/javascript&quot;&gt; var tet; &lt;/script&gt;
            
            
            jsPos = false;
            return new CKEDITOR.htmlParser.element( 'img', attributes );
        }
        else {
            return element;
        }
    }
    
    CKEDITOR.plugins.add( 'scriptcode',
    {
    	init : function( editor )
    	{
    		editor.addMenuItems(
    		{
    			inscode :
    			{
    				label : 'Quellcode bearbeiten',
    				command : 'scriptcode',
                    icon : this.path + 'editcode.png',
    				group : 'inscode'
    			}
    		});
    		
    		editor.contextMenu.addListener( function( element, selection )
    		{
    			if ( element && element.is( 'img' ) && !element.isReadOnly() && element.data( 'cke-real-element-type' ) == 'code' )
    				
                    return { inscode : CKEDITOR.TRISTATE_OFF };
    		});
    
        	editor.addCss(
        		'img.cke_jscode' +
        		'{' +
        			'background-image: url(' + CKEDITOR.getUrl( this.path + 'js_code.png' ) + ');' +
        			'background-position: center center;' +
        			'background-repeat: no-repeat;' +
        			'background-color: #FFFF00;' +
        			'width: 28px;' +
        			'height: 13px;' +
        			'vertical-align: middle;' +
        		'}' +
        		'img.cke_phpcode' +
        		'{' +
        			'background-image: url(' + CKEDITOR.getUrl( this.path + 'php_code.png' ) + ');' +
        			'background-position: center center;' +
        			'background-repeat: no-repeat;' +
        			'background-color: #FFFF00;' +
        			'width: 37px;' +
        			'height: 13px;' +
        			'vertical-align: middle;' +
        		'}'
    		);
    
    		editor.on( 'doubleclick', function( evt )
    		{
    			var element = evt.data.element;
    
    			if ( element.is( 'img' ) && element.data( 'cke-real-element-type' ) == 'code' ) {
    				evt.data.dialog = 'scriptcode';
    			}
    		});
    		
            editor.addCommand( 'scriptcode', new CKEDITOR.dialogCommand( 'scriptcode' ) ) ;
    
    		editor.ui.addButton( 'ScriptCode',
    		{
    			label : 'Quellcode einfügen',
    			icon : this.path + 'inscode.png',
    			command : 'scriptcode'
    		});
    		
    		CKEDITOR.dialog.add( 'scriptcode', this.path + 'dialogs/scriptcode.js' );
    	},
    	
    	afterInit : function( editor )
    	{
    		var dataProcessor = editor.dataProcessor,
    			dataFilter = dataProcessor && dataProcessor.dataFilter;
            
    		if ( dataFilter )
    		{
    			dataFilter.addRules(
    			{
    				comment : function( element )
    				{
    				    return createCodePlaceholder( editor, element );
    				}
    			},
                2);
    		}
    	},
    	
        requires : [ 'fakeobjects' ]
    });
})();
