CKEDITOR.on 'instanceCreated', ({editor}) -> editor.on 'pluginsLoaded', ->
  {TRISTATE_OFF: ENABLED, TRISTATE_DISABLED: DISABLED} = CKEDITOR
  RedrawSubMenuName = null
  OffsetsByLevel = []

  row = editor.getMenuItem('tablerow')
  rowItems = row.getItems()
  row.getItems = ->
    sel = editor.getSelection()
    $.extend {
      tablerow_moveBefore: if isFirstRow(sel) then DISABLED else ENABLED
      tablerow_moveAfter: if isLastRow(sel) then DISABLED else ENABLED
    }, rowItems

  col = editor.getMenuItem('tablecolumn')
  colItems = col.getItems()
  col.getItems = ->
    sel = editor.getSelection()
    $.extend {
      tablecolumn_moveBefore: if isFirstColumn(sel) then DISABLED else ENABLED
      tablecolumn_moveAfter: if isLastColumn(sel) then DISABLED else ENABLED
    }, colItems

  editor.addMenuItems
    tablerow_moveBefore:
      label: 'Move Row Before'
      group: 'tablerow'
      command: 'rowMoveBefore'
      order: 11
    tablerow_moveAfter:
      label: 'Move Row After'
      group: 'tablerow'
      command: 'rowMoveAfter'
      order: 12
    tablecolumn_moveBefore:
      label: 'Move Column Before'
      group: 'tablecolumn'
      command: 'columnMoveBefore'
      order: 11
    tablecolumn_moveAfter:
      label: 'Move Column After'
      group: 'tablecolumn'
      command: 'columnMoveAfter'
      order: 12

  editor.addCommand "rowMoveBefore",
    exec: (editor) -> moveRowBefore editor.getSelection()
  editor.addCommand "rowMoveAfter",
    exec: (editor) -> moveRowAfter editor.getSelection()
  editor.addCommand "columnMoveBefore",
    exec: (editor) -> moveColumnBefore editor.getSelection()
  editor.addCommand "columnMoveAfter",
    exec: (editor) -> moveColumnAfter editor.getSelection()

  for key in ['rowInsertBefore', 'rowInsertAfter', 'columnInsertBefore', 'columnInsertAfter']
    cmd = editor._.commands[key]
    continue if cmd._origExec
    subMenuName = "table#{ key.replace(/Insert.*/, '') }"
    do (cmd, subMenuName) ->
      cmd._origExec = cmd.exec
      cmd.exec = (args...) ->
        rv = @_origExec(args...)
        redrawContextMenu subMenuName
        return rv

  MenuElement = null
  CKEDITOR.ui.on 'ready', ({data}) ->
    MenuElement = data if data._?.panel

  editor.on 'menuShow', ({data}) ->
    return unless RedrawSubMenuName
    panel = data[0]
    level = panel._.definition.level
    setTimeout((->
      panel.element.setStyles OffsetsByLevel[level]
      for item, idx in MenuElement.items
        continue unless item.name == RedrawSubMenuName
        do (MenuElement, idx) -> setTimeout((-> MenuElement._.showSubMenu idx), 100)
        RedrawSubMenuName = null
        return
    ), 1)

  # Utility functions to detect edge of tables.

  isFirstRow = (selection) ->
    cells = getSelectedCells( selection )
    firstCell = cells[0]
    startRow = firstCell.getParent()
    startRowIndex = startRow.$.rowIndex
    return true if startRowIndex == 0
    table = firstCell.getAscendant( 'table' )
    rowCells = table.$.rows[0].cells
    maxRowSpan = Math.max((mapCell.rowSpan for mapCell in rowCells)...)
    return startRowIndex <= (maxRowSpan-1)

  isLastRow = (selection) ->
    cells = getSelectedCells( selection )
    lastCell = cells[ cells.length - 1 ]
    table = lastCell.getAscendant( 'table' )
    endRow = lastCell.getParent()
    rowCells = endRow.$.cells
    endRowIndex = endRow.$.rowIndex
    maxRowSpan = Math.max((mapCell.rowSpan for mapCell in rowCells)...)
    return ((endRowIndex + maxRowSpan) >= table.$.rows.length)

  isFirstColumn = (selection) ->
    cells = getSelectedCells( selection )
    startColIndex = getColumnsIndices( cells, 1 )
    return (startColIndex == 0)

  isLastColumn = (selection) ->
    cells = getSelectedCells( selection )
    endColIndex = getColumnsIndices( cells )
    lastRow = cells[ cells.length - 1 ].getParent()
    rowCells = lastRow.$.cells
    colIndex = -1
    for mapCell in rowCells
      colIndex += mapCell.colSpan
      return false if colIndex > endColIndex
    return true

  $$ = (elm) -> new CKEDITOR.dom.element(elm)

  moveRowBefore = (selection) ->
    cells = getSelectedCells( selection )
    endRow = cells[ cells.length - 1 ].getParent()
    firstCell = cells[ 0 ]
    startRowIndex = firstCell.getParent().$.rowIndex
    table = firstCell.getAscendant( 'table' )
    prevRow = table.$.rows[startRowIndex - 1]
    $$(prevRow).insertAfter endRow
    redrawContextMenu 'tablerow'

  moveRowAfter = (selection) ->
    cells = getSelectedCells( selection )
    startRow = cells[ 0 ].getParent()
    lastCell = cells[ cells.length - 1 ]
    endRowIndex = lastCell.getParent().$.rowIndex + lastCell.$.rowSpan - 1
    table = lastCell.getAscendant( 'table' )
    nextRow = table.$.rows[endRowIndex + 1]
    $$(nextRow).insertBefore startRow
    redrawContextMenu 'tablerow'

  moveColumn = (selection, isBefore) ->
    cells = getSelectedCells( selection )
    table = cells[0].getAscendant( 'table' )
    startColIndex = getColumnsIndices( cells, 1 )
    endColIndex = getColumnsIndices( cells )
    for row in table.$.rows
      rowCells = row.cells
      if isBefore
        $$(rowCells[startColIndex - 1]).insertAfter $$(rowCells[endColIndex])
      else
        $$(rowCells[endColIndex + 1]).insertBefore $$(rowCells[startColIndex])
    redrawContextMenu 'tablecolumn'

  moveColumnBefore = (selection) ->
    moveColumn selection, true

  moveColumnAfter = (selection) ->
    moveColumn selection, false

  redrawContextMenu = (subMenuName) ->
    RedrawSubMenuName = subMenuName
    for elm, idx in $('.cke_contextmenu').get()
      $parent = $(elm).parent()
      OffsetsByLevel[idx] =
        top: $parent.css('top')
        left: $parent.css('left')
    editor.execCommand 'contextMenu'

  # Everything below is copied from tabletools/plugin.js #
  cellNodeRegex = /^(?:td|th)$/

  getSelectedCells = (selection) ->
    bookmarks = selection.createBookmarks()
    ranges = selection.getRanges()
    retval = []
    database = {}
    i = 0

    moveOutOfCellGuard = (node) ->
      return if retval.length > 0
      if node.type is CKEDITOR.NODE_ELEMENT and cellNodeRegex.test(node.getName()) and not node.getCustomData("selected_cell")
        CKEDITOR.dom.element.setMarker database, node, "selected_cell", true
        retval.push node
      return

    for range in ranges
      if range.collapsed
        startNode = range.getCommonAncestor()
        nearestCell = startNode.getAscendant("td", true) or startNode.getAscendant("th", true)
        retval.push nearestCell  if nearestCell
      else
        walker = new CKEDITOR.dom.walker(range)
        node = undefined
        walker.guard = moveOutOfCellGuard
        while (node = walker.next())
          parent = node.getAscendant("td") or node.getAscendant("th")
          if parent and not parent.getCustomData("selected_cell")
            CKEDITOR.dom.element.setMarker database, parent, "selected_cell", true
            retval.push parent

    CKEDITOR.dom.element.clearAllMarkers database
    selection.selectBookmarks bookmarks
    return retval

  getColumnsIndices = (cells, isStart) ->
    retval = (if isStart then Infinity else 0)
    for cell in cells
      colIndex = getCellColIndex(cell, isStart)
      if isStart
        retval = colIndex if colIndex < retval
      else
        retval = colIndex if colIndex > retval
    return retval

  getCellColIndex = (cell, isStart) ->
    row = cell.getParent()
    rowCells = row.$.cells
    colIndex = 0

    for mapCell in rowCells
      colIndex += (if isStart then 1 else mapCell.colSpan)
      break if mapCell is cell.$
    return colIndex - 1
