﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Web.Routing" %>
<%@ Import Namespace="System.Web.DynamicData" %>

<script RunAt="server">
    public static void RegisterRoutes(RouteCollection routes) {
        MetaModel model = new MetaModel();
        model.RegisterContext(typeof(DataClassesDataContext), new ContextConfiguration() { ScaffoldAllTables = true });
         
        //                    WICHTIG: REGISTRIERUNG DES DATENMODELLS 
        // Kommentar für diese Zeile entfernen, um LINQ to SQL-Klassen zu registrieren
        // modell für ASP.NET Dynamic Data zu registrieren. ScaffoldAllTables = true nur festlegen, wenn 
        // alle Tabellen im Datenmodell eine Gerüstansicht (z.B. Vorlagen) unterstützen sollen. 
        // Zum Steuern des Gerüstbaus für einzelne Tabellen eine partielle Klasse für 
        // die Tabelle erstellen und das [Scaffold(true)]-Attribut auf die Klasse anwenden.
        // Hinweis: Sie müssen YourDataContextType in den Namen der Datenkontextklasse
        // in Ihrer Anwendung ändern.
        //model.RegisterContext(typeof(YourDataContextType), new ContextConfiguration() { ScaffoldAllTables = false });

        // Die folgende Anweisung unterstützt den Modus mit separaten Seiten, bei dem die Aufgaben Auflisten, Details anzeigen, Einfügen und 
        // Aktualisieren mithilfe von separaten Seiten ausgeführt werden. Zum Aktivieren dieses Modus die Auskommentierung der folgenden 
        // route-Definition sowie der route-Definitionen im folgenden Abschnitt für den Modus mit kombinierten Seiten aufheben.
        routes.Add(new DynamicDataRoute("{table}/{action}.aspx") {
            Constraints = new RouteValueDictionary(new { action = "List|Details|Edit|Insert" }),
            Model = model
        });

        // Die folgenden Anweisungen unterstützen den Modus mit kombinierten Seiten, bei dem die Aufgaben Auflisten, Details anzeigen, Einfügen und
        // Aktualisieren mithilfe derselben Seite ausgeführt werden. Zum Aktivieren dieses Modus die Auskommentierung
        // der folgenden routes sowie der route-Definition im vorherigen Abschnitt für den Modus mit separaten Seiten aufheben.
        //routes.Add(new DynamicDataRoute("{table}/ListDetails.aspx") {
        //    Action = PageAction.List,
        //    ViewName = "ListDetails",
        //    Model = model
        //});

        //routes.Add(new DynamicDataRoute("{table}/ListDetails.aspx") {
        //    Action = PageAction.Details,
        //    ViewName = "ListDetails",
        //    Model = model
        //});
    }

    void Application_Start(object sender, EventArgs e) {
        RegisterRoutes(RouteTable.Routes);
    }

</script>
