﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.DynamicData;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class test : System.Web.UI.Page
{
    DataClassesDataContext db = new DataClassesDataContext();

    private Guid InstitutionID { get { return new Guid("7d8d101e-f119-4ad8-a95b-12c204e2bb1d"); } }

    private Guid SelectedContentID
    {
        get
        {
            object oGuidContent = gvContents.SelectedValue;
            if (oGuidContent == null)
                return new Guid();

            return (Guid)oGuidContent;
        }
    }

    
    private string ContentType { get; set; }


    protected void Page_Init()
    {
        fv.EnableDynamicData(typeof(Content));
        

        //DynamicDataManager1.RegisterControl(gvDocuments, false /*setSelectionFromUrl*/);


    }


    protected void Page_Load(object sender, EventArgs e)
    {

     
        object objType = "N";
        ContentType = (string)objType;

        var content = new Content();

        // default valiues (important remark: they will only be set if the properties are displayed in UI (habe a DynamicControl))
        Dictionary<string, object> dictDefValues = new Dictionary<string, object>();
        dictDefValues.Add("ID", System.Guid.NewGuid());
        dictDefValues.Add("ContentType", ContentType);

        fv.SetMetaTable(fv.GetMetaTable(), dictDefValues);

     


        ReAttachContentDataSourcenAndDataBind();

        //fv.Visible = false;
    }


    /// <summary>
    /// Sort. Details see http://stackoverflow.com/questions/213148/sort-columns-of-gridview-in-asp-net-c/357276#357276
    /// another possibility would probably be: http://stackoverflow.com/questions/2841585/create-linq-to-entities-orderby-expression-on-the-fly 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <param name="source"></param>
    /// <param name="sortExpression"></param>
    /// <param name="direction"></param>
    /// <returns></returns>
    public static IQueryable<T> SortBy<T>(IQueryable<T> source, string sortExpression, SortDirection direction)
    {
        if (source == null)
            throw new ArgumentNullException("source");

        string methodName = "OrderBy";
        if (direction == SortDirection.Descending)
            methodName += "Descending";

        var paramExp = Expression.Parameter(typeof(T), String.Empty);
        var propExp = Expression.PropertyOrField(paramExp, sortExpression);
        // p => p.sortExpression
        var sortLambda = Expression.Lambda(propExp, paramExp);
        var methodCallExp = Expression.Call(
            typeof(Queryable),
            methodName,
            new[] { typeof(T), propExp.Type },
            source.Expression,
            Expression.Quote(sortLambda)
            );
        return (IQueryable<T>)source.Provider.CreateQuery(methodCallExp);
    }

    protected void ReAttachContentDataSourcenAndDataBind()
    {
        var contentZuordnungenIDS = db.InstitutionContentZuordnungen.Where(p => p.InstitutionID == InstitutionID).Select(p => p.ContentID);
        var contents = db.Content.Where(p => p.ContentType == ContentType && contentZuordnungenIDS.Contains(p.ID));
        string strSortExpression = (string)ViewState["gvSE"];
        object objSortDirection = ViewState["gvSO"];
        if (strSortExpression != null && objSortDirection != null)
            gvContents.DataSource = SortBy(contents, strSortExpression, (SortDirection)objSortDirection);
        else
            gvContents.DataSource = contents;
        gvContents.DataBind();
    }



    protected void lbNew_Click(object sender, EventArgs e)
    {
        fv.DefaultMode = FormViewMode.Insert;
        fv.DataBind();
    }
    protected void gvContents_SelectedIndexChanged(object sender, EventArgs e)
    {
        

    }
    protected void fv_ItemUpdated(object sender, FormViewUpdatedEventArgs e)
    {
        db.Refresh(System.Data.Linq.RefreshMode.OverwriteCurrentValues, db.Content);
        ReAttachContentDataSourcenAndDataBind();
    }
    protected void fv_ItemCreated(object sender, EventArgs e)
    {

    }
    protected void fv_ItemInserted(object sender, FormViewInsertedEventArgs e)
    {
        if (e.AffectedRows > 0)
        {
            InstitutionContentZuordnungen icz = new InstitutionContentZuordnungen();
            icz.ID = System.Guid.NewGuid();
            
            Guid gContent = new Guid((string)e.Values["ID"]);
            var c = db.Content.Where(p => p.ID == gContent);

            icz.ContentID = gContent;
            icz.InstitutionID = InstitutionID;
            db.InstitutionContentZuordnungen.InsertOnSubmit(icz);
            db.SubmitChanges();

            db.Refresh(System.Data.Linq.RefreshMode.OverwriteCurrentValues, db.Content);
            ReAttachContentDataSourcenAndDataBind();
        }

        Response.Redirect("test.aspx", true);

    }


    protected void fv_ItemInserting(object sender, FormViewInsertEventArgs e)
    {
        //e.Values.Add("ID", System.Guid.NewGuid()); // no, pre-poluated throught .NET 4 mechanism!

        if (e.Values.Contains("ChangedTS"))
            e.Values.Remove("ChangedTS");

        e.Values.Add("ChangedTS", System.DateTime.Now.ToString("yyyyMMdd_HHmmss"));

        if (e.Values.Contains("ContentType"))
            e.Values.Remove("ContentType");

        e.Values.Add("ContentType", ContentType);


        if (!e.Values.Contains("ID"))
            e.Values.Add("ID", System.Guid.NewGuid());

        fv.DefaultMode = FormViewMode.ReadOnly;
    }


    protected void gvContents_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Guid guidDContent = (Guid)gvContents.DataKeys[e.RowIndex].Value; //SelectedDocumenttID [row is not selected]

        if (guidDContent == new Guid())
            return;

        var contToDelete = db.Content.Single(p => p.ID == guidDContent);
        //var instContZuordToDelete = db.InstitutionContentZuordnungen.Single(p => p.ContentID == guidDContent);
        //db.InstitutionContentZuordnungen.DeleteOnSubmit(instContZuordToDelete);
        db.Content.DeleteOnSubmit(contToDelete);
        db.SubmitChanges();
        ReAttachContentDataSourcenAndDataBind();                
    }


    protected void gvContents_Sorting(object sender, GridViewSortEventArgs e)
    {
        object objSD = ViewState["gvSO"];
        if (objSD == null)
            ViewState["gvSO"] = e.SortDirection;
        else
        {
            SortDirection sd = (SortDirection)objSD;
            ViewState["gvSO"] = (sd == SortDirection.Ascending ? SortDirection.Descending : SortDirection.Ascending);
        }
        ViewState["gvSE"] = e.SortExpression;
        ReAttachContentDataSourcenAndDataBind();
    }

    protected void gvContents_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvContents.PageIndex = e.NewPageIndex;
        gvContents.DataBind();
    }

    protected void gvContents_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.Header)
        {
            foreach (TableCell tc in e.Row.Cells)
            {
                if (tc.HasControls())
                {
                    // search for the header link
                    LinkButton lnk = (LinkButton)tc.Controls[0];
                    if (lnk != null)
                    {
                        // inizialize a new image
                        System.Web.UI.WebControls.Image img = new System.Web.UI.WebControls.Image();
                        // setting the dynamically URL of the image
                        object objSortDirection = ViewState["gvSO"];
                        SortDirection sd = SortDirection.Ascending;
                        if (objSortDirection != null)
                            sd = (SortDirection)objSortDirection;
                        img.ImageUrl = "~/img/ico_" + (sd == SortDirection.Ascending ? "asc" : "desc") + ".gif";
                        // checking if the header link is the user's choice
                        string strSortExpression = (string)ViewState["gvSE"];
                        if (strSortExpression != null && strSortExpression == lnk.CommandArgument)
                        {
                            // adding a space and the image to the header link
                            img.CssClass = "sortarrow";
                            tc.Controls.Add(img);
                        }
                    }
                }
            }
        }

    }

    private object callContentFunction(string methodName, params object[] parameters)
    {
        Type contentType = this.Page.GetType();
        System.Reflection.MethodInfo mi = contentType.GetMethod(methodName);
        if (mi == null)
            return null;
        return mi.Invoke(this.Page, parameters);
    }
    protected void gvContents_RowEditing(object sender, GridViewEditEventArgs e)
    {

    }
    protected void gvContents_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {

    }
    protected void fv_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        lbNew.Visible = !(e.CommandName == "Edit" || e.CommandName == "New");
    }
    protected void fv_ItemUpdating(object sender, FormViewUpdateEventArgs e)
    {

        if (e.NewValues.Contains("ChangedTS"))
            e.NewValues.Remove("ChangedTS");
        e.NewValues.Add("ChangedTS", System.DateTime.Now.ToString("yyyyMMdd_HHmmss"));

        Page.Validate();
        if (!Page.IsValid)
        {
            //FormViewValidator.Display = ValidatorDisplay.Dynamic;
            FormViewValidator.Text = "blafassel";
            FormViewValidator.ErrorMessage = "blafasselXXXXXXXX";
            e.Cancel = true;
        }


    }
    
    
    protected void fv_ModeChanging(object sender, FormViewModeEventArgs e)
    {
        bool bC = e.CancelingEdit;
        bool b = e.Cancel;
        FormViewMode m = e.NewMode;

        if (e.CancelingEdit || e.Cancel)
        {
            e.NewMode = FormViewMode.ReadOnly;
            //fv.DefaultMode = FormViewMode.ReadOnly; // not necessary
            fv.DataBind();
            up_fv.Update();
        }

    }
}