
(function()
{
	var cssifyLength = CKEDITOR.tools.cssLength;

    function getStyle(Style, Name)
    {
        var Styles = Style.split(';');
        for( var i = 0; i < Styles.length; i++ )
        {
            var styleAttr = Styles[i].split(':');
            if( CKEDITOR.tools.trim( styleAttr[0] ).toLowerCase() == Name )
            {
                result = CKEDITOR.tools.trim( styleAttr[1] );
                break;
            }
        }
        return result ? result : '';
    }

	function createFakeElement( editor, realElement, width, height )
	{
		var fakeElement = editor.createFakeParserElement( realElement, 'cke_fakediv', 'myfakediv', true );
		
		var fakeStyle = fakeElement.attributes.style || '';
        fakeStyle = fakeElement.attributes.style = fakeStyle + 'width:' + cssifyLength( width ) + ';';
        fakeStyle = fakeElement.attributes.style = fakeStyle + 'height:' + cssifyLength( height ) + ';';

		return fakeElement;
	}

    CKEDITOR.plugins.add( 'fakediv',   
    {
        init : function( editor )
        {
        	editor.addCss(
        		'img.cke_fakediv {' +
    			'	background-color: #a2a2a2;' +
    			'	border: 1px solid #a9a9a9;' +
        		'}'
    		);
        },
    	afterInit : function( editor )
    	{
    		var dataProcessor = editor.dataProcessor,
    			dataFilter = dataProcessor && dataProcessor.dataFilter;
        	
    		if( dataFilter )
    		{
    			dataFilter.addRules(
    			{
    				elements :
    				{
    					div : function( element )
    					{
                            var attributes = element.attributes;
							if(attributes[ 'class' ] == 'myfakedivsframe')
							{
                                var width = getStyle(attributes[ 'style' ], 'width') || '100';
                        		var height = getStyle(attributes[ 'style' ], 'height') || '100';
                        		return createFakeElement( editor, element, width, height );
							}
    					}
    				}
    			});
    		}
    	},
        requires : [ 'dialog', 'fakeobjects' ]
    });
})();

