﻿/*
Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @file AutoGrow plugin
 */
(function(){

	// Actual content height, figured out by simply check the last element's document position.
	function docContentHeight( doc, scrollable )
	{
		// Always create marker, to account for margin
		// ??? Any reason to use <SPAN> here? it doesn't account for floated elements (old problem with autogrow...)
		// !!! Please check IE6 and quirks
		// TODO: div style can be affected by document stylesheets. Needs complete reset (display:block, reset width, left, top, bottom, what else???) and !important
		last = CKEDITOR.dom.element.createFromHtml( '<div style="position:absolute; clear:both; height:1px; line-height:1px"></div>', doc );
		doc.getBody().append( last );
		var height = last.getDocumentPosition( doc ).y;
		last.remove();
		// Depending on browser, and whether body has margin, largest of these is valid
		return Math.max( scrollable.$.scrollHeight, height );
	}

	CKEDITOR.plugins.add( 'autogrow',
	{
		init : function( editor )
		{
			// The offset size between content height and editor size.
			var contentMargin = 0;
			var resizeEditor = function( editor )
			{
				if ( !editor.window )
					return;

				var doc = editor.document,
					resizeable = editor.getResizable( 1 );
				var	body = doc.getBody(),
					htmlElement = doc.getDocumentElement(),
					currentHeight = resizeable.$.offsetHeight,
					newHeight;

				// Quirks mode overflows body except for IE9, standards overflows document element.
				var scrollable = !CKEDITOR.env.ie9Compat && doc.$.compatMode == 'BackCompat' ? body : htmlElement;

				// Get maximum possible height
				newHeight = docContentHeight( doc, scrollable );
				if ( newHeight != currentHeight ) {
					// And resize to it
					resizeable.setStyle( 'height', newHeight + 'px' );
					// If vertical scrollbar disappeared
					if ( scrollable.$.clientWidth >= scrollable.$.scrollWidth )
						// Resize down to size gained by removal of vertical and horizontal scrollbar
						newHeight = docContentHeight( doc, scrollable );
					else
						// Otherwise add height of scrollbar
						newHeight += scrollable.$.offsetHeight - scrollable.$.clientHeight;

					var min = editor.config.autoGrow_minHeight,
						max = editor.config.autoGrow_maxHeight;

					( min == undefined ) && ( editor.config.autoGrow_minHeight = min = 200 );
					if ( min )
						newHeight = Math.max( newHeight, min );
					if ( max )
						newHeight = Math.min( newHeight, max );

					if ( newHeight != currentHeight )
					{
						newHeight = editor.fire( 'autoGrow', { currentHeight : currentHeight, newHeight : newHeight } ).newHeight;
						editor.fire( 'resize' );
					}
					resizeable.setStyle( 'height', newHeight + 'px' );
				}
			};

			for ( var eventName in { contentDom:1, key:1, selectionChange:1, insertElement:1 } )
			{
				editor.on( eventName, function( evt )
				{
					var maximize = editor.getCommand( 'maximize' );
					// Some time is required for insertHtml, and it gives other events better performance as well.
					if ( evt.editor.mode == 'wysiwyg' &&
						// Disable autogrow when the editor is maximized .(#6339)
						( !maximize || maximize.state != CKEDITOR.TRISTATE_ON ) )
					{
						setTimeout( function(){ resizeEditor( evt.editor ); }, 100 );
					}
			});
		}
		}
	});
})();
/**
 * The minimum height to which the editor can reach using AutoGrow.
 * @name CKEDITOR.config.autoGrow_minHeight
 * @type Number
 * @default 200
 * @since 3.4
 * @example
 * config.autoGrow_minHeight = 300;
 */

/**
 * The maximum height to which the editor can reach using AutoGrow. Zero means unlimited.
 * @name CKEDITOR.config.autoGrow_maxHeight
 * @type Number
 * @default 0
 * @since 3.4
 * @example
 * config.autoGrow_maxHeight = 400;
 */

/**
 * Fired when the AutoGrow plugin is about to change the size of the editor.
 * @name CKEDITOR.editor#autogrow
 * @event
 * @param {Number} data.currentHeight The current height of the editor (before the resizing).
 * @param {Number} data.newHeight The new height of the editor (after the resizing). It can be changed
 *				to determine another height to be used instead.
 */
