/**
 * Created by IntelliJ IDEA.
 * User: Henrik
 * Date: 01-09-2011
 * Time: 11:30:29
 * To change this template use File | Settings | File Templates.
 */

var undoGroup = [ 'Undo','Redo' ];
var cutCopyPasteGroup = [ 'Cut','Copy','Paste','PasteText','PasteWord' ];
var boldItalicUnderlineGroup = ['Bold', 'Italic', 'Underline', 'Superscript', 'Subscript' ];
var linkGroup = [ 'Link', 'Unlink', 'Symbol' ];

//Toolbar when no appropiate section could be found
var EMPTY_TOOLBAR = [
    undoGroup,
    [ 'Copy' ]
];

//Toolbar for label text
var LABEL_TOOLBAR = [
    undoGroup,
    cutCopyPasteGroup,
    [ 'Italic', 'Superscript', 'Subscript' ],
    [ 'Symbol' ]
];

//Toolbar for simple text
var SIMPLE_SECTION_TOOLBAR = [
    undoGroup,
    cutCopyPasteGroup,
    boldItalicUnderlineGroup,
    linkGroup
];

//Toolbar for body text
var BODY_TOOLBAR = [
        undoGroup,
        cutCopyPasteGroup,
        boldItalicUnderlineGroup,
        [ 'BulletedList', 'NumberedList', 'Indent', 'Outdent' ],
        linkGroup,
        [ 'Table' ]
];

function getNewEditor( div ) {
    var toolbarName = $( div ).attr( 'toolbar' );
    var toolbar = getToolbar( toolbarName );

    //Create a new editor with a correct toolbar
    var editor = CKEDITOR.replace( div, { toolbar : toolbar } );

    return editor;
}

function getToolbar( toolbarType ) {
    switch( toolbarType ) {
        case 'LABEL_TEXT': return LABEL_TOOLBAR;
        case 'SIMPLE_SECTION_TEXT': return SIMPLE_SECTION_TOOLBAR;
        case 'BODY_TEXT': return BODY_TOOLBAR;
        default:
            alert( "Missing toolbarType: " + toolbarType );
            return EMPTY_TOOLBAR;
    }
}

/*Utility function used for debugging (it is NOT availible in IE*/
function debug( msg ) {
    if ( navigator.userAgent.indexOf( "MSIE" ) == -1 ) {
        log( msg );
    }
}

function log( msg ) {
    console.log( msg );
}

