﻿function configEditor( editorId, localeName, submitCallback, mode )
{
	CKEDITOR.replace( editorId );

	CKEDITOR.editorConfig = function( config )
	{
		config.language = localeName.substring( 0, 2 );

		config.toolbar =
		[
			['Bold', 'Italic', 'Underline', 'Strike', '-', 'NumberedList', 'BulletedList', '-'], //, 'Outdent', 'Indent', '-'],
			['Undo','Redo', '-'],
			//['SpellChecker', '-'],
			//['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock', '-'],
			//['FontSize', '-'],
			['Link', 'Unlink', '-'],
			['Image', 'Flash']
		];

		config.resize_enabled = false;

		config.toolbarCanCollapse = false;

		config.fontSize_sizes = 'Маленький/small;Средний/medium;Большой/large';
		config.fontSize_defaultLabel = 'Средний';

		config.filebrowserImageUploadUrl = '/upload.py';

		config.image_previewText = ' ';
		config.removeDialogTabs = 'image:advanced;image:Link;link:target;link:advanced';

		config.removePlugins = 'scayt,elementspath,contextmenu';

		// SL-1511: paste from Word
		//config.enterMode = CKEDITOR.ENTER_DIV;
		//config.shiftEnterMode = CKEDITOR.ENTER_DIV;

		config.entities = false; // do not replace symbols for HTML entities (ex.<a href="http://pravkniga.ru/intervews.html?id=1193&amp">http://pravkniga.ru/intervews.html?id=1193&amp</a>;re=12345</div>)
		
		// SL-1511: forcePasteAsPlainText works only for keyboard shortcuts and does not work for copy/paste via context menus
		//config.forcePasteAsPlainText = true;

		this.addCommand( 'ctrlEnter',
		{
    			exec : function()
			{			
				submitCallback( editorId );
    			}
		});	

		config.keystrokes =
		[
			[ CKEDITOR.ALT + 121 /*F10*/, 'toolbarFocus' ],
			//[ CKEDITOR.ALT + 122 /*F11*/, 'elementsPathFocus' ],

			[ CKEDITOR.SHIFT + 121 /*F10*/, 'contextMenu' ],
			[ CKEDITOR.CTRL + CKEDITOR.SHIFT + 121 /*F10*/, 'contextMenu' ],

			[ CKEDITOR.CTRL + 90 /*Z*/, 'undo' ],
			[ CKEDITOR.CTRL + 89 /*Y*/, 'redo' ],
			[ CKEDITOR.CTRL + CKEDITOR.SHIFT + 90 /*Z*/, 'redo' ],

			[ CKEDITOR.CTRL + 76 /*L*/, 'link' ],		
			[ CKEDITOR.CTRL + 13 /*ENTER*/, 'ctrlEnter' ],
			//[ CKEDITOR.CTRL + 66 /*B*/, 'bold' ],
			//[ CKEDITOR.CTRL + 73 /*I*/, 'italic' ],
			//[ CKEDITOR.CTRL + 85 /*U*/, 'underline' ],

			[ CKEDITOR.ALT + 109 /*-*/, 'toolbarCollapse' ],
			[ CKEDITOR.ALT + 48 /*0*/, 'a11yHelp' ]
		];

		if( CKEDITOR.env.opera )
		{
			config.blockedKeystrokes =
			[
				//CKEDITOR.CTRL + 66 /*B*/, - fix CKEditor bug on Opera
				CKEDITOR.CTRL + 73 /*I*/,
				CKEDITOR.CTRL + 85 /*U*/			
			];
		}

		// evaluate SCAYT on startup  
		//config.scayt_autoStartup = true;  
		// needs to migrate your pages to licensed server version from trial  
		// set up your own path to service  
		//config.scayt_srcUrl = 'http://your_host/path_to_scayt.js' ;  
		// set up max suggestion count in context menu  
		// all other words will be present in "More Suggestions" sub menu  
		//config.scayt_maxSuggestions = 4;  
		// needs to migrate to hosted service from trial  
		// set up encrypted customer id   
		//config.scayt_customerid = "encrypted_customer_id";  
		// set up SCAYT default language   
		//config.scayt_sLang = localeName;  
		//config.scayt_moreSuggestions = 'off';  
		// customize the display of SCAYT context menu commands ("Add Word", "Ignore"  
		// and "Ignore All"). It must be a string with one or more of the following  
		// words separated by a pipe ("|"):  
		// "off": disables all options.  
		// "all": enables all options.  
		// "ignore": enables the "Ignore" option.  
		// "ignoreall": enables the "Ignore All" option.  
		// "add": enables the "Add Word" option.  
		//config.scayt_contextCommands = 'add|ignoreall';  
		// set the visibility of the SCAYT tabs in the settings dialog and toolbar  
		// button. The value must contain a "1" (enabled) or "0" (disabled) number for  
		// each of the following entries, in this precise order, separated by a  
		// comma (","): "Options", "Languages" and "Dictionary".  
		//config.scayt_uiTabs = '1,0,1';  
		// Define order of placing of SCAYT context menu items by groups.  
		// It must be a string with one or more of the following  
		// words separated by a pipe ("|"):  
		// 'suggest' - main suggestion word list  
		// 'moresuggest' - more suggestions word list  
		// 'control' - SCAYT commands, such as 'Ignore' and 'Add Word'  
		//config.scayt_contextMenuItemsOrder ='moresuggest|control|suggest';  

		config.disableNativeSpellChecker = false;
	
            	CKEDITOR.document.on("dragstart", function(ev)
            	{
	            	var domEvent = ev.data;
			domEvent.preventDefault();
		});		

		if( mode == 'message' )
		{
			//Установка курсора в конец текста в редакторе
			CKEDITOR.on( 'instanceReady', function(ev) {	        		
				setCursor( editorId, ev );
			} );
		}
	}
}

function setCursor( editorId, ev )
{	
	ev.editor.focus();
	data = CKEDITOR.instances[ editorId ].getData();			
	
	if( data != "" )
	{			
        	var s = ev.editor.getSelection(); // getting selection			
        	var selected_ranges = s.getRanges()[0]; // getting ranges
        	var node = selected_ranges.startContainer; // selecting the starting node
        	var parents = node.getParents( true );

        	node = parents[ parents.length - 2 ].getFirst();

        	while( true ) {
        		var x = node.getNext();
        		if ( x == null ) {
        			break;
		        }
        	 	node = x;
        	}

        	s.selectElement( node );
        	selected_ranges = s.getRanges()[0];
        	selected_ranges.collapse( true );  //  false collapses the range to the end of the selected node, true before the node.
        	s.selectRanges( selected_ranges );  // putting the current selection there
	}
    	
}

function filterHtml( text )
{
	text = text.replace(/&(lt|gt);/g, function (strMatch, p1){
 		 	return (p1 == "lt")? "<" : ">";
 		});

 	text = text.replace( /&nbsp;/g, "" );

	return text.replace(/<\/?[^>]+(>|$)/g, "");
}

function isEditorEmpty( text )
{
	var filtered = filterHtml( text );

	return filtered == '' || filtered.replace(/\s+/g, '').length == 0;
}
