Ext.define('MyApp.view.CkEditor',{
	extend:'Ext.form.field.TextArea',
	requires: ['Ext.ckeditor.*'],
	alias:'widget.ckeditor',
	margin: '0',

	bReadOnly: false,      // read only flag

	initComponent:function()
	{
		// console.error('ckEditor --> initComponent');
		this.callParent(arguments);
		this.on('afterrender',function() {
			// console.error('ckEditor --> afterrender, height: ' + this.getHeight())
			Ext.apply(this.CKConfig, {height:this.getHeight()});
			this.editor = CKEDITOR.replace(this.inputEl.id, {
				extraPlugins: /*'lyrisFooterTagsBtn,lyrisMergeTagsBtn,lyrisEnhancerTagsBtn,*/'stylesheetparser,onchange',
				toolbar: [
					{name: 'source',      items: ['Source']},
					{name: 'document',    items: ['Preview', 'Print']},
					{name: 'editing',     items: ['Find', 'Replace', 'SelectAll','-', 'SpellChecker', 'Scayt']},
					{name: 'clipboard',   items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo']},
					{name: 'links',       items: ['Link', 'Unlink', 'Anchor']},
					{name: 'colors',      items: ['TextColor','BGColor']},
					{name: 'insert',      items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar']},
					//{name: 'lyris',       items: ['lyrisFooterTagsBtn', 'lyrisMergeTagsBtn', 'lyrisEnhancerTagsBtn']},
					{name: 'tools',       items: ['ShowBlocks' ,'-', 'About', '-', 'Templates']},
					'/',
					{name: 'styles',      items: ['Styles', 'Format', 'Font', 'FontSize']},
					{name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat']},
					{name: 'paragraph',   items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'/*, '-', 'BidiLtr', 'BidiRtl'*/]}
					],

				toolbarCanCollapse: false,      // remove the collapse from the toolbar
				removePlugins: 'resize, elementspath',        // disable the resize of plugin
				resize_enabled: false,          // disable the resize (done display the icon)
				browserContextMenuOnCtrl: true, // enable context menu when rigth click with the control button pressed
				contentsCss: CKEDITOR.basePath + 'lyrisCKEditor.css',
				height: this.getHeight(),       // set the height
				minimumChangeMilliseconds: 100, // 100 milliseconds
				autoGrow_onStartup: true,
				//customConfig: "../../../../ckeditor/config.js",
				fullPage: true,                 // full html page
				skin: 'v2'                      // what skin to use
				});

			this.editorId = this.editor.id;

			var self = this;
			this.editor.on('change', function(e) {
				if (self.bReadOnly)
					return

				var p = Ext.getCmp('contenteditor');
				p.fireEvent('contentChanged');
				});
		},this);
	}, // initComponent

	onRender:function(ct, position)
	{
		//console.log("CKEditor --> onRender");
		if(!this.el) {
			this.defaultAutoCreate = {
				tag:'textarea',
				autocomplete:'off'
				};
		}
		this.callParent(arguments);
	}, // onRender

	setValue:function(value)
	{
		//console.log("CKEditor --> setValue");
		this.callParent(arguments);
		if(this.editor) {
			this.editor.setData(value);
			}
	}, // setValue

	setContentId: function(value)
	{
		//this.contentId = value;
	}, // setContentId

	getRawValue:function()
	{
		//console.log("CKEditor --> getRawValue");
		if (this.editor) {
			try {
				return this.editor.getData();
				}
			catch (e) {
				return '';
				}
			}
		else {
			return '';
			}
	}, // getRawValue

	setReadOnly: function(bReadOnly)
	{
		//console.log("CKEditor --> setReadOnly");
		if (bReadOnly == undefined)
			bReadOnly = true;

		// seave the flag
		this.bReadOnly = bReadOnly;

		// set/clear the read only flag
		if (this.bReadOnly) {
			this.editor.setReadOnly(true);
			}
		else {
			this.editor.setReadOnly(false);
			}
	}, // setReadOnly

	insertHtml : function(html)
	{
		this.editor.insertHtml(html);
	} // insertHtml
});

// configure the CKEditor
CKEDITOR.on('instanceReady', function(e)
{
	// get the size of the containing window
	var instance = Ext.ComponentQuery.query('ckeditor[editorId="'+ e.editor.id +'"]'),
	comp = instance[0];
	var ownerBox = comp.ownerCt.getBox();

	// if a height was configured by the editor use it
	var height = ownerBox.height;
	if (e.editor.config.height != undefined)
		height = e.editor.config.height

	// resize the editor
	// console.error("CkEditor --> instanceReady: " + ownerBox.width + ", " + ownerBox.height + ", " + height);						
	e.editor.resize(ownerBox.width - 10, height);

	// handle resize
	comp.on('resize',function(c, adjWidth, adjHeight) {
		// console.error('CkEditor --> resize: ' + adjWidth + ", " + adjHeight)
		c.editor.resize(adjWidth, adjHeight);
		});
});

// disable resize of dialogs
CKEDITOR.on('dialogDefinition', function( ev )
{
	ev.data.definition.resizable = CKEDITOR.DIALOG_RESIZE_NONE;
});

CKEDITOR.on('change', function(e)
{
	console.warn("ckedit changed!!!!!!!")
});
