/*
 * @example An iframe-based dialog with frame window fit dialog size.
 */

( function() {
    
	var iframeWindow = null;
	
	CKEDITOR.plugins.add( 'iframe-fit-size',
    {
        requires: [ 'iframedialog' ],
        init: function( editor )
        {
			var height = 480, width = 750;
			CKEDITOR.dialog.addIframe(
				'myiframedialogDialog',
				'Smiley',
				'http://192.168.1.100:8080/releases/ckeditor/3.6.3/ckeditor/_samples/replacebyclass.html', 
				width, 
				height,
				function()
				{
					// Iframe loaded callback.		
					var iframe = document.getElementById( this._.frameId );
					iframeWindow = iframe.contentWindow;	//get refernce to iframe window
				},	
				{			
					
					//buttons: [ CKEDITOR.dialog.cancelButton ], //CKEDITOR.dialog.okButton, 
					//onHide : function() { alert('ff'); } //with only cancel use onHide event or onCancel
					
					onOk : function()
					{				
						this._.editor.insertHtml(iframeWindow.document.getElementById('editor1').value);//This takes text from textarea (not from editor!!!) and insersts it into parent editor.
						this._.editor.insertHtml(iframeWindow.CKEDITOR.instances['editor1'].getData());//This takes HTML from editor and insersts it into parent editor. 
						//alert(iframeWindow.foo()); //call function defined in replacebyclass sample !!!!!!!!!!
						// <script>var foo = function() {return 'foo!';}</script> // Page in iframe must have something like this!!!!!!!!!!!!!			
					}
				}
			);

			editor.addCommand( 'myiframedialog', new CKEDITOR.dialogCommand( 'myiframedialogDialog' ) );

            editor.ui.addButton( 'Myiframedialog',
            {
                label: 'My Iframe in dialog',
                command: 'myiframedialog',
                icon: this.path + 'images/icon.png'
            } );
        }
    } );

} )();

//Way to extend toolbar in a plugin provided that full toolbar is used.
var toolbar = CKEDITOR.config.toolbar_Full;
toolbar[toolbar.length-1].items.push( 'Myiframedialog' );