﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace TestControls
{
	/// <summary>
	/// This textbox is implemented in the way CKEditorControl handles postback data.
	/// </summary>
	public class BrokenTextBox : TextBox, IPostBackDataHandler
	{
		private bool isChanged = false;

		protected override void OnPreRender(EventArgs e)
		{
			base.OnPreRender(e);
			if (isChanged)
			{
				OnTextChanged(e);
			}
		}

		bool IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection)
		{
			string postedValue = HttpUtility.HtmlDecode(postCollection[postDataKey]);
			if (Text != postedValue)
			{
				isChanged = true;
				Text = postedValue;
				return true;
			}
			return false;
		}

		void IPostBackDataHandler.RaisePostDataChangedEvent()
		{
		}
	}

	// This textbox is implemented in the way suggested by me 6 years ago:
	// https://dev.ckeditor.com/ticket/1364

	public class WorkingTextBox : TextBox, IPostBackDataHandler
	{
		bool IPostBackDataHandler.LoadPostData(string postDataKey, NameValueCollection postCollection)
		{
			string postedValue = HttpUtility.HtmlDecode(postCollection[postDataKey]);
			if (Text != postedValue)
			{
				Text = postedValue;
				return true;
			}
			return false;
		}
		void IPostBackDataHandler.RaisePostDataChangedEvent()
		{
			OnTextChanged(EventArgs.Empty);
		}
	}
}