﻿<%@ Page Language="C#" AutoEventWireup="true" %>
<%@ Register TagPrefix="test" Namespace="TestControls" Assembly="TestControls" %>
<html>
	<body>
		<form runat="server">
			<asp:Panel runat="server" ID="panel">
				broken: <test:BrokenTextBox ID="btb" runat="server" /><br />
				working: <test:WorkingTextBox ID="wtb" runat="server" /><br />
				standard: <asp:TextBox ID="tb" runat="server" />
			</asp:Panel>

			<p /><asp:Button runat="server" Text="Run test" OnClick="Button_Click" />
			
			<p /><asp:Label ID="output" runat="server" />
		</form>
	</body>

	<script runat="server">
		void Page_Load(object src, EventArgs e)
		{
			// this never fires because the control is removed by the time its PreRender event would have
			// been fired, which is why the change event should not be fired in that event. It should happen
			// during the processing of post data, which is how the other two textboxes work
			btb.TextChanged += (obj, args) => { output.Text += "broken changed: " + btb.Text + "<br/>"; }; 
			
			// this is a textbox with postdata handling implemented properly
			wtb.TextChanged += (obj, args) => { output.Text += "working changed: " + wtb.Text + "<br/>"; };
			
			// this is a standard System.Web.UI.WebControls.TextBox
			tb.TextChanged += (obj, args) => { output.Text += "standard changed: " + tb.Text + "<br/>"; };
		}

		void Button_Click(object src, EventArgs e)
		{
			// remove the textboxes.
			panel.Controls.Clear();
		}
	</script>
</html>