CKEDITOR.plugins.add( 'pastemenu',
{
	init : function( editor )
	{		
		editor.ui.add( 'Paste', CKEDITOR.UI_MENUBUTTON,
		{
			label : 'Paste Menu',
			title : 'Paste Menu',
			toolbar : 'clipboard,20',
			modes : { wysiwyg : 1 },
			onMenu : function()
			{
				return {
					'paste': CKEDITOR.TRISTATE_OFF,
					'pastetext': CKEDITOR.TRISTATE_OFF, 
					'pastefromword': CKEDITOR.TRISTATE_OFF	
				};
			},
			onRender: function()
			{
				if ( editor.addMenuItems ) {						
				
					editor.addMenuItems({
						pastetext : {
							command : 'pastetext',
							group : 'clipboard',
							label : 'Paste as plain text',
							order : 8						
						},
						pastefromword : {
							command : 'pastefromword',
							group : 'clipboard',
							label : 'Paste from Word',
							order : 8						
						}						
					});
				}
			}
		});
	}
});