﻿/* helpers */

function clearScrollTimer()
{
	clearTimeout(objScrollTimer);
	objScrollTimer = null;
}

function helperHTMLEncode(strText)
{
	return strText.replace(/\&/g, "&amp;").replace(/\>/g, "&gt;").replace(/\</g, "&lt;");
}

function helperCreateXML(strXML)
{
	var objItem;
	var objXML = document.createElement("XML");
	
	objXML.loadXML(strXML);	
	objItem = objXML.selectNodes("item")[0];	
	objXML = null;
	
	return objItem;
}

function helperShowContextMenu(objMenus, objEvent, objOptionalBase)
{
	var objPopup =	window.createPopup();
	var objPopupDoc = objPopup.document;
	var objPopupBody = objPopupDoc.body;
	var intI;
	
	objPopupDoc.createStyleSheet().cssText = document.styleSheets[document.styleSheets.length - 1].cssText;
		
	objPopupBody.className = "FE_ContextMenu";
	objPopupBody.oncontextmenu = function () { return false };
	objPopupBody.ondragstart = function () { return false };
	
	window.popup = objPopup;
	
	var objDiv = objPopupDoc.createElement("DIV");
	
	for (intI = 0; intI < objMenus.length; intI ++)
	{	
		var objAnchor = objPopupDoc.createElement("A");
		var strURL = "../../../images/formeditor/contextmenu/blank.gif";
		var objImg = objPopupDoc.createElement("IMG");
		var objImgSpan = objPopupDoc.createElement("SPAN");
		var objTextSpan = objPopupDoc.createElement("SPAN");
		
		objAnchor.href = "#";
		objTextSpan.innerText = objMenus[intI].text;
		objTextSpan.className = "Text";
		
		if (objMenus[intI].image)
			strURL = "../../../images/formeditor/contextmenu/" + objMenus[intI].image;
		
		objImg.height = 16;
		objImg.width = 16;
		objImg.src = strURL;
		//objImg.align = "absmiddle";
		
		objImgSpan.appendChild(objImg);
		objImgSpan.appendChild(objPopupDoc.createTextNode(" "));
		objImgSpan.className = "Image";
		
		if (objOptionalBase)
		{
			objAnchor.instance = objOptionalBase.child;
			objAnchor.base = objOptionalBase;
			objAnchor.commandID = intI;
			objAnchor.onclick = objOptionalBase.child.contextMenuClicked;
		}
		else
		{
			eval("objAnchor.onclick = " + objMenus[intI].call);
		}
		
		if (!objMenus[intI].available)
		{
			objAnchor.onclick = function () { return false };
			objAnchor.className = "FE_ContextMenu_ItemDisabled";
			objImgSpan.className = "ImageDisabled";
			objTextSpan.className = "TextDisabled";
		}
		
		objAnchor.appendChild(objImgSpan);
		objAnchor.appendChild(objTextSpan);
		objDiv.appendChild(objAnchor);
	}
	
	objPopupBody.appendChild(objDiv);

	objPopup.show(objEvent.clientX, objEvent.clientY, 200, 1, document.body);
	
	objPopup.show(objEvent.clientX, objEvent.clientY, objDiv.clientWidth + 2, objDiv.clientHeight + 2, document.body);
}

function helperHideContextMenu()
{
	if (window.popup)
		window.popup.hide();
	
	window.popup = null;
}

function helperShowTip(intX, intY, strElementID)
{
	var objElement = document.getElementById(strElementID);
	
	if (!objElement || objElement.tooltip == "")
		return;		
	
	var objPopup =	window.createPopup();
	var objPopupDoc = objPopup.document;
	var objPopupBody = objPopupDoc.body;
	
	objPopupDoc.createStyleSheet().cssText = document.styleSheets[document.styleSheets.length - 1].cssText;
		
	objPopupBody.className = "FE_Tooltip";
	objPopupBody.oncontextmenu = function () { return false };
	objPopupBody.ondragstart = function () { return false };
	
	window.popup = objPopup;
	
	var objTable = objPopupDoc.createElement("TABLE")
	var objRow = objTable.insertRow();
	var objCell = objRow.insertCell();
	
	intX += 12;
	intY += 12;

	objCell.innerHTML = objElement.tooltip;
	
	objPopupBody.appendChild(objTable);
	
	objPopup.show(intX, intY, 200, 0, document.body);
	
	if (intX + objTable.clientWidth + 2 > intMaxX)
		intX = (intX - 16) - (objTable.clientWidth + 2); 
		
	if (intY + objTable.clientHeight + 2 > intMaxY)
		intY = (intY - 16) - (objTable.clientHeight + 2); 
	
	objPopup.show(intX, intY, objTable.clientWidth + 2, objTable.clientHeight + 2, document.body);
	
}

function helperHideTip()
{
	helperHideContextMenu();
}